// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : level.h
// Date           : February 2008
//
// Description    : This file defines the Level class used for parsing the
//                  text-based level files and storing level data for use.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once


#include <vector>
#include <list>
#include <windows.h>

#include "global.h"



class Entity;
class EntityPlayer;
class EntityParticle;
class Game;

class Level 
{

  protected:

    bool                        m_Keys[4];

    Dobbs::Tile*                m_Tiles;
    Dobbs::TileType*            m_BackgroundTiles;
    Dobbs::TileType*            m_ForegroundTiles;

    int                         m_Width;
    int                         m_Height;

    int                         m_Tokens;

    float                       m_WibbleProgress;

    int                         m_WibbleArray[29][22][2];


    void                        WakeUpOrSleep( Entity* pEntity );
    void                        UpdateWibbleArray();

    bool                        m_DisplayLayer[3];


  public:

    int                         m_OffsetX;
    int                         m_OffsetY;

    int                         m_Number;

    std::string                 m_Name;

    std::list<Entity*>          m_Entities;

    EntityPlayer*               m_pPlayer;

    Game*                       m_pGame;


    Level( Game* pGame );
    ~Level();


    void                        Clear();
    void                        ClearEntities();

    void                        DeleteSpawnedEntityAt( int x, int y );

    void                        initBasic();

    void                        UpdateTimed( float ElapsedTime );
    void                        Update();


    Dobbs::TileType             Tile( int tx, int ty );
    DWORD                       TileColor( int tx, int ty );
    Dobbs::Tile&                FullTile( int tx, int ty );

    Dobbs::TileType             TileFromLayer( int Layer, int tx, int ty );

    void                        SetTile( int Layer, int X, int Y, Dobbs::TileType NewTile );

    Entity*                     SpawnEntity( const Dobbs::EntityTypes Entity, int StartDir, int X, int Y );
    Entity*                     FindSpawnedEntityFrom( int X, int Y );
    void                        RemoveEntity( Entity* pEntity );
    Entity*                     FindEntityByType( const Dobbs::EntityTypes Entity );

    bool                        Save( int Nr );
    bool                        Load( int Nr );

    int                         Width();
    int                         Height();

    bool                        IsDone();
    void                        TokenCollected();


    void                        Resize( int NewWidth, int NewHeight );

    bool                        IsBlocked( Entity* pEntity, int X, int Y );

    Entity*                     FindCollidingEntity( Entity* pEntity, Dobbs::EntityTypes Type );
    Entity*                     FindEntityAt( int X, int Y );

    void                        Render( DWORD ModulateColor );

    bool                        IsTileBlocking( Entity* pEntity, Dobbs::TileType Tile, Dobbs::TileType FGTile, int DirFlags );
    bool                        IsAreaBlocked( Entity* pEntity, RECT& rc, int DirFlags );

    bool                        IsTileDeadly( Entity* pEntity, Dobbs::TileType Tile, int DirFlags );
    bool                        IsAreaDeadly( Entity* pEntity, RECT& rc, int DirFlags );

    bool                        BlockingEntity( Entity* pEntity1, Entity* pEntity2, int DirFlags );
    bool                        BlockedByEntity( Entity* pEntity, RECT& rc, int DirFlags );

    bool                        IsPlatform( Entity* pEntity );
    bool                        CheckPlatformBelow( Entity* pEntity );

    bool                        CanMove( Entity* pEntity, int DX, int DY, int DirFlags );
    bool                        Move( Entity* pEntity, int DX, int DY, int DirFlags );

    bool                        CanCollide( Dobbs::EntityTypes Type );
    bool                        CanCollide( Dobbs::EntityTypes Type, Dobbs::EntityTypes Type2 );
    bool                        Collide( Entity* pEntity, Entity* pEntity2 );

    Dobbs::TileType             TileBehindEntity( Entity* pEntity, int DX = 0, int DY = 0 );


    void                        EnableLayer( int Layer, bool Enable = true );
    bool                        LayerEnabled( int Layer );

    void                        ReplaceTile( Dobbs::TileType Tile1, Dobbs::TileType Tile2 );

    void                        InsertEntity( Entity* pEntity );

    EntityParticle*             SpawnParticle( Dobbs::ParticleType Type, int X, int Y, unsigned int Color = -1 );

};


